/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lothrazar.cyclic.recipe.ingredient.FluidTagIngredient;
import com.lothrazar.cyclic.util.FluidHelpers;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeUtil {
    public static boolean matchFluid(FluidStack tileFluid, FluidTagIngredient ing) {
        if (tileFluid == null || tileFluid.isEmpty()) {
            return false;
        }
        if (ing.hasFluid() && tileFluid.getFluid() == ing.getFluidStack().getFluid()) {
            return true;
        }
        if (ing.hasTag()) {
            TagKey ft = FluidTags.create((ResourceLocation)new ResourceLocation(ing.getTag()));
            if (FluidHelpers.matches(tileFluid.getFluid(), (TagKey<Fluid>)ft)) {
                return true;
            }
        }
        return false;
    }

    public static FluidTagIngredient parseFluid(JsonObject json, String key) {
        JsonObject mix = json.get(key).getAsJsonObject();
        int count = mix.get("count").getAsInt();
        if (count < 1) {
            count = 1;
        }
        FluidStack fluidstack = FluidStack.EMPTY;
        if (mix.has("fluid")) {
            String fluidId = mix.get("fluid").getAsString();
            ResourceLocation resourceLocation = new ResourceLocation(fluidId);
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(resourceLocation);
            fluidstack = fluid == null ? FluidStack.EMPTY : new FluidStack(fluid, count);
        }
        String ftag = mix.has("tag") ? mix.get("tag").getAsString() : "";
        return new FluidTagIngredient(fluidstack, ftag, count);
    }

    public static NonNullList<Ingredient> getIngredientsArray(JsonObject obj) {
        JsonArray array = GsonHelper.m_13933_((JsonObject)obj, (String)"ingredients");
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (int i = 0; i < array.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)array.get(i));
            if (ingredient.m_43947_()) continue;
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public static FluidStack getFluid(JsonObject fluidJson) {
        if (fluidJson.has("fluidTag")) {
            // empty if block
        }
        String fluidId = GsonHelper.m_13906_((JsonObject)fluidJson, (String)"fluid");
        ResourceLocation resourceLocation = new ResourceLocation(fluidId);
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(resourceLocation);
        int count = fluidJson.get("count").getAsInt();
        if (count < 1) {
            count = 1;
        }
        return new FluidStack(fluid, count);
    }
}

